# Google Sheets & Vercel 設定ガイド

## 1. Google Cloud Platform (GCP) の設定

1. [Google Cloud Console](https://console.cloud.google.com/) にアクセスします。
2. **新しいプロジェクト**を作成します（例: "kakeibo-app"）。
3. 検索バーで **"Google Sheets API"** を検索し、**有効化 (Enable)** します。
4. **IAM と管理 (IAM & Admin)** > **サービス アカウント (Service Accounts)** に移動します。
5. **サービス アカウントを作成 (Create Service Account)** をクリックします。
   - サービスアカウント名: `kakeibo-bot` （なんでもOKです）
   - 「完了」をクリック。
6. 作成されたサービスアカウント（メールアドレスのようなID）をクリックします。
7. **キー (Keys)** タブ > **鍵を追加 (Add Key)** > **新しい鍵を作成 (Create new key)** > **JSON** を選択します。
8. JSONファイルがダウンロードされます。**このファイルは後で使うので大切に保管してください。**

## 2. Google スプレッドシートの設定

1. [sheets.new](https://sheets.new) にアクセスして新しいスプレッドシートを作成します。
2. 名前を適当に付けます（例: "家計簿DB"）。
3. 右上の **共有 (Share)** ボタンをクリックします。
4. 先ほどダウンロードしたJSONファイルの中にある `client_email` の値をコピーし、共有相手の欄に貼り付けます。
   - 権限: **編集者 (Editor)**
   - 「通知する」のチェックは外してOKです。
   - **送信 (Share)** をクリック。
5. ブラウザのURLバーから **シートID (Sheet ID)** を取得します：
   - URL: `https://docs.google.com/spreadsheets/d/`**`1aBcD...XYZ`**`/edit`
   - 太字の部分がIDです。

## 3. Vercel へのデプロイ

1. [Vercel](https://vercel.com/) にアクセスし、**New Project** を追加します。
2. `kakeibo-app` リポジトリをインポートします。
3. **Environment Variables** (環境変数) のセクションで、以下の変数を追加します（値はダウンロードしたJSONファイルからコピーしてください）：

| 変数名 (Name) | 値の参照元 (Value Source) |
| :--- | :--- |
| `GOOGLE_SERVICE_ACCOUNT_EMAIL` | JSON内の `client_email` |
| `GOOGLE_PRIVATE_KEY` | JSON内の `private_key` (`-----BEGIN...` から始まる文字列すべてをコピー) |
| `GOOGLE_SHEET_ID` | 手順2で取得したシートID |

1. **Deploy** をクリックします。

## ローカルでの開発 (.env)

ローカル環境で動かすには、プロジェクトのルートディレクトリに `.env.local` ファイルを作成し、同じ変数を設定してください：

```bash
GOOGLE_SERVICE_ACCOUNT_EMAIL="your-email@..."
GOOGLE_PRIVATE_KEY="-----BEGIN PRIVATE KEY-----\n..."
GOOGLE_SHEET_ID="your-sheet-id"
```
