# Kakeibo App (家計簿アプリ)

Next.js と Google Sheets で動作する、シンプルで高速な家計簿アプリです。
スマホファーストで設計されており、毎日の支出入力がストレスなく行えます。

## 特徴

- 📱 **スマホ最適化**: iPhoneなどのスマホブラウザでネイティブアプリのように使えます。
- 💸 **残高管理**: 「予算 - (固定費 + 使用額)」で、"今月あといくら使えるか" がひと目で分かります。
- 📝 **Google Sheets連携**: データは全てご自身のGoogleスプレッドシートに保存されます。データの編集・分析も自由自在です。
- ☁️ **完全無料運用**: Vercel (Hobbyプラン) と Google Cloud (無料枠) で、完全無料で運用可能です。

---

## 導入手順

このアプリを使用するには、以下の3つのステップが必要です。

1. **Google Cloud のセットアップ** (APIと鍵の取得)
2. **スプレッドシートの準備**
3. **Vercel へのデプロイ** (アプリの公開)

### 1. Google Cloud のセットアップ

アプリがあなたのスプレッドシートにアクセスするために、「サービスアカウント」を作成します。

1. [Google Cloud Console](https://console.cloud.google.com/) にアクセスし、新しいプロジェクトを作成します（名前は `kakeibo` など）。
2. 左メニュー「APIとサービス」>「ライブラリ」から **"Google Sheets API"** を検索し、「有効にする」をクリックします。
3. 左メニュー「IAMと管理」>「サービスアカウント」を開き、「サービスアカウントを作成」をクリックします。
   - 名前: `kakeibo-bot` など（任意）
   - アクセス権: 設定不要（省略可）
4. 作成されたサービスアカウントのメールアドレス（`xxx@xxx.iam.gserviceaccount.com`）をメモします。
5. 作成したサービスアカウントをクリックし、「キー」タブ > 「鍵を追加」> 「新しい鍵を作成」> **JSON** を選択します。
   - JSONファイルがダウンロードされます。この中身（特に `private_key`）はパスワードと同じなので、他人に教えないでください。

### 2. スプレッドシートの準備

1. [Googleスプレッドシート](https://sheets.new)で新しいシートを作成します。
2. 右上の「共有」ボタンをクリックし、**先ほどメモしたサービスアカウントのメールアドレス** を入力して「編集者」として共有します。
3. ブラウザのURLバーを見て、スプレッドシートIDをメモします。
   - `https://docs.google.com/spreadsheets/d/` **ここがID** `/edit...`

### 3. Vercel へのデプロイ

アプリをインターネット上に公開します。

1. **GitHubリポジトリの準備**:
   - 右上の「Fork」ボタン、またはこのコードをダウンロードしてご自身のGitHubにアップロードしてください。
2. **Vercel アカウント作成**:
   - [Vercel](https://vercel.com/) にアクセスし、GitHubアカウントでログインします。
3. **新規プロジェクト作成**:
   - "Add New" > "Project" を選択し、先ほどのリポジトリをImportします。
4. **環境変数の設定 (Environment Variables)**:
   - "Environment Variables" のセクションを展開し、以下の3つを入力します。

| Key | Value (入力する値) |
| :--- | :--- |
| `GOOGLE_SERVICE_ACCOUNT_EMAIL` | サービスアカウントのメールアドレス |
| `GOOGLE_PRIVATE_KEY` | ダウンロードしたJSON内の `private_key` の値（`-----BEGIN PRIVATE KEY...` から全て） |
| `GOOGLE_SHEET_ID` | スプレッドシートのID |

1. **Deploy**:
   - "Deploy" ボタンをクリックします。1分ほどで完了し、URLが発行されます。

---

## 使い方

1. 発行されたURLにスマホでアクセスします。
2. ホーム画面に追加（iPhoneなら共有ボタン > 「ホーム画面に追加」）すると、アプリのように使えます。
3. 初回アクセス時、自動的にスプレッドシートに必要なヘッダー行などが書き込まれます。
4. 設定画面から、カテゴリや予算を設定してください。

## 注意事項

- スプレッドシートの1行目（ヘッダー）の文字を変更すると、アプリが動かなくなる可能性があります。
- データがおかしくなった場合は、スプレッドシートを直接修正してください。
