import Link from 'next/link'
import EntryForm from '@/components/EntryForm'
import BudgetStatus from '@/components/BudgetStatus'
import HistoryList from '@/components/HistoryList'
import { getEntries, getCategories, getPaymentMethods, seedDefaults, getBudget, getMonthlyTotal, getFixedCosts } from '@/app/actions'

export default async function Home() {
  // Ensure default data exists
  await seedDefaults()

  const today = new Date()
  const currentMonth = `${today.getFullYear()}-${String(today.getMonth() + 1).padStart(2, '0')}`

  const [entries, categories, paymentMethods, budget, monthlyData, fixedCosts] = await Promise.all([
    getEntries(),
    getCategories(),
    getPaymentMethods(),
    getBudget(currentMonth),
    getMonthlyTotal(currentMonth),
    getFixedCosts(),
  ])

  return (
    <div className="container">
      <header style={{ marginBottom: '1.5rem', display: 'flex', justifyContent: 'space-between', alignItems: 'center' }}>
        <h1 style={{ fontSize: '1.5rem' }}>家計簿</h1>
        <Link href="/settings" className="btn-outline" style={{ fontSize: '0.8rem', padding: '0.4rem 0.8rem', textDecoration: 'none' }}>設定</Link>
      </header>

      <BudgetStatus
        budget={budget?.amount ?? null}
        monthlyData={monthlyData}
        fixedCosts={fixedCosts}
      />

      <EntryForm
        categories={categories}
        paymentMethods={paymentMethods}
      />

      <HistoryList
        entries={entries}
        categories={categories}
        paymentMethods={paymentMethods}
      />
    </div>
  )
}
