import Link from 'next/link'
import { getCategories, getPaymentMethods, getFixedCosts, getBudget } from '@/app/actions'
import CategorySettings from '@/components/settings/CategorySettings'
import PaymentMethodSettings from '@/components/settings/PaymentMethodSettings'
import BudgetSettings from '@/components/settings/BudgetSettings'
import FixedCostSettings from '@/components/settings/FixedCostSettings'

export default async function SettingsPage() {
    const today = new Date()
    const currentMonth = `${today.getFullYear()}-${String(today.getMonth() + 1).padStart(2, '0')}`

    const [categories, paymentMethods, fixedCosts, budget] = await Promise.all([
        getCategories(),
        getPaymentMethods(),
        getFixedCosts(),
        getBudget(currentMonth)
    ])

    return (
        <div className="container">
            <header style={{ marginBottom: '1.5rem', display: 'flex', alignItems: 'center', gap: '1rem' }}>
                <Link href="/" className="btn-outline">← 戻る</Link>
                <h1 style={{ fontSize: '1.5rem' }}>設定</h1>
            </header>

            <div style={{ display: 'flex', flexDirection: 'column', gap: '1rem' }}>
                <BudgetSettings initialBudget={budget?.amount ?? null} initialMonth={currentMonth} />
                <FixedCostSettings fixedCosts={fixedCosts} categories={categories} paymentMethods={paymentMethods} />
                <CategorySettings categories={categories} />
                <PaymentMethodSettings paymentMethods={paymentMethods} />
            </div>
        </div>
    )
}
