export default function BudgetStatus({
    budget,
    monthlyData,
    fixedCosts
}: {
    budget: number | null
    monthlyData: { total: number, variable: number, fixed: number }
    fixedCosts: any[]
}) {
    const totalFixedCostSettings = fixedCosts.reduce((acc, fc) => acc + fc.amount, 0)
    // Remaining = Budget - FixedCostSettings (planned) - VariableSpent (actual)
    const usage = totalFixedCostSettings + monthlyData.variable
    const remaining = budget !== null ? budget - usage : null

    return (
        <div className="card" style={{ background: 'var(--primary-color)', color: '#fff', marginBottom: '1.5rem' }}>
            <h2 style={{ fontSize: '0.875rem', opacity: 0.9 }}>今月の予算状況</h2>
            <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'flex-end', marginTop: '0.5rem' }}>
                <div>
                    <div style={{ fontSize: '0.75rem', opacity: 0.8 }}>残り</div>
                    <div style={{ fontSize: '2rem', fontWeight: 'bold' }}>
                        {remaining !== null ? `¥${remaining.toLocaleString()}` : '---'}
                    </div>
                </div>
                <div style={{ textAlign: 'right' }}>
                    <div style={{ fontSize: '0.75rem', opacity: 0.8 }}>予算: {budget ? `¥${budget.toLocaleString()}` : '未設定'}</div>
                    <div style={{ fontSize: '0.75rem', opacity: 0.8 }}>固定費(予): ¥{totalFixedCostSettings.toLocaleString()}</div>
                    <div style={{ fontSize: '0.75rem', opacity: 0.8 }}>変動費(実): ¥{monthlyData.variable.toLocaleString()}</div>
                </div>
            </div>
        </div>
    )
}
