'use client'
import { setBudget } from '@/app/actions'

export default function BudgetSettings({ initialBudget, initialMonth }: { initialBudget: number | null, initialMonth: string }) {
    async function action(formData: FormData) {
        await setBudget(formData.get('month') as string, Number(formData.get('amount')))
        alert('保存しました')
    }

    return (
        <div className="card">
            <h3 className="label" style={{ fontSize: '1.2rem', marginBottom: '1rem' }}>月予算設定</h3>
            <form action={action}>
                <div className="input-group">
                    <label className="label">対象月</label>
                    <input name="month" type="month" className="input" defaultValue={initialMonth} required />
                </div>
                <div className="input-group">
                    <label className="label">予算額</label>
                    <input name="amount" type="number" className="input" defaultValue={initialBudget || ''} placeholder="¥0" required />
                </div>
                <button className="btn" style={{ width: '100%' }}>保存</button>
            </form>
        </div>
    )
}
