'use client'
import { useRef } from 'react'
import { addCategory, deleteCategory, updateCategory } from '@/app/actions'

export default function CategorySettings({ categories }: { categories: any[] }) {
    const formRef = useRef<HTMLFormElement>(null)

    async function handleAdd(formData: FormData) {
        const res = await addCategory(formData)
        if (res.success) formRef.current?.reset()
        else alert(res.error)
    }

    return (
        <div className="card">
            <h3 className="label" style={{ fontSize: '1.2rem', marginBottom: '1rem' }}>カテゴリー編集</h3>
            <ul style={{ marginBottom: '1rem', listStyle: 'none' }}>
                {categories.map(c => (
                    <li key={c.id} style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', padding: '0.5rem 0', borderBottom: '1px solid var(--border-color)' }}>
                        <span>{c.name}</span>
                        <div style={{ display: 'flex', gap: '0.5rem' }}>
                            <button
                                onClick={() => {
                                    const newName = prompt('新しいカテゴリー名', c.name);
                                    if (newName && newName !== c.name) {
                                        updateCategory(c.id, newName).then(res => !res.success && alert(res.error));
                                    }
                                }}
                                style={{
                                    background: 'none',
                                    border: '1px solid var(--primary-color)',
                                    color: 'var(--primary-color)',
                                    borderRadius: '4px',
                                    padding: '2px 8px',
                                    cursor: 'pointer'
                                }}
                            >
                                編集
                            </button>
                            <button
                                onClick={() => {
                                    if (confirm('削除しますか？')) deleteCategory(c.id).then(res => !res.success && alert(res.error))
                                }}
                                style={{
                                    background: 'none',
                                    border: '1px solid var(--danger-color)',
                                    color: 'var(--danger-color)',
                                    borderRadius: '4px',
                                    padding: '2px 8px',
                                    cursor: 'pointer'
                                }}
                            >
                                削除
                            </button>
                        </div>
                    </li>
                ))}
            </ul>
            <form ref={formRef} action={handleAdd} style={{ display: 'flex', gap: '0.5rem' }}>
                <input name="name" className="input" placeholder="新しいカテゴリー" required style={{ flex: 1 }} />
                <button type="submit" className="btn">追加</button>
            </form>
        </div>
    )
}
