'use client'
import { useRef } from 'react'
import { addFixedCost, deleteFixedCost, applyFixedCosts } from '@/app/actions'

export default function FixedCostSettings({
    fixedCosts,
    categories,
    paymentMethods
}: {
    fixedCosts: any[],
    categories: any[],
    paymentMethods: any[]
}) {
    const formRef = useRef<HTMLFormElement>(null)

    async function handleAdd(formData: FormData) {
        const res = await addFixedCost(formData)
        if (res.success) formRef.current?.reset()
        else alert('Error adding fixed cost')
    }

    async function handleApply() {
        const month = prompt('反映する月を入力してください (YYYY-MM)', new Date().toISOString().slice(0, 7))
        if (!month) return
        if (confirm(`${month} の家計簿に固定費 ${fixedCosts.length}件 を反映しますか？`)) {
            const res = await applyFixedCosts(month)
            if (res.success) alert(`${res.count}件 追加しました`)
        }
    }

    return (
        <div className="card">
            <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', marginBottom: '1rem' }}>
                <h3 className="label" style={{ fontSize: '1.2rem', marginBottom: 0 }}>固定費設定</h3>
                <button onClick={handleApply} className="btn-outline" style={{ fontSize: '0.8rem' }}>今月に反映</button>
            </div>

            <ul style={{ marginBottom: '1rem', listStyle: 'none' }}>
                {fixedCosts.map(fc => (
                    <li key={fc.id} style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', padding: '0.5rem 0', borderBottom: '1px solid var(--border-color)' }}>
                        <div>
                            <div style={{ fontWeight: 'bold' }}>{fc.name}</div>
                            <div style={{ fontSize: '0.75rem', color: 'var(--text-muted)' }}>
                                {fc.dayOfMonth}日 · ¥{fc.amount.toLocaleString()} · {fc.category.name}
                            </div>
                        </div>
                        <button
                            onClick={() => {
                                if (confirm('削除しますか？')) deleteFixedCost(fc.id)
                            }}
                            style={{
                                background: 'none',
                                border: '1px solid var(--danger-color)',
                                color: 'var(--danger-color)',
                                borderRadius: '4px',
                                padding: '2px 8px',
                                cursor: 'pointer'
                            }}
                        >
                            削除
                        </button>
                    </li>
                ))}
            </ul>

            <form ref={formRef} action={handleAdd} style={{ display: 'flex', flexDirection: 'column', gap: '0.5rem' }}>
                <div style={{ display: 'flex', gap: '0.5rem' }}>
                    <input name="name" className="input" placeholder="名称 (例: 家賃)" required style={{ flex: 1 }} />
                    <input name="dayOfMonth" type="number" min="1" max="31" className="input" placeholder="日" required style={{ width: '60px' }} />
                </div>
                <div style={{ display: 'flex', gap: '0.5rem' }}>
                    <input name="amount" type="number" className="input" placeholder="金額" required style={{ flex: 1 }} />
                    <select name="categoryId" className="select" required style={{ flex: 1 }}>
                        <option value="" disabled selected>カテゴリ</option>
                        {categories.map(c => <option key={c.id} value={c.id}>{c.name}</option>)}
                    </select>
                </div>
                <select name="paymentMethodId" className="select">
                    <option value="">支払方法 (任意)</option>
                    {paymentMethods.map(p => <option key={p.id} value={p.id}>{p.name}</option>)}
                </select>
                <button type="submit" className="btn">追加</button>
            </form>
        </div>
    )
}
